using System;
using System.Collections;
using J2EE.Naming;
using J2EE.Rmi;
using com.borland.examples.ejb.shoppingcart;

class CartClient {

  static void Main(string[] args) {
    try {
      // bootstrap to the J2EE naming service
      Context root = new InitialContext(args);
      
      // resolving CartHome object from the naming context
      object homeObj = root.Lookup("shoppingcart/remote/cart");
      CartHome home = (CartHome) PortableRemoteObject.Narrow(homeObj, typeof(CartHome));

      // creating a new instance of Cart session
      string cardHolderName = "Jack B. Quick";
      string creditCardNumber = "1234-5678-9012-3456";
      DateTime expirationDate = new DateTime();
      Cart cart = home.Create(cardHolderName, creditCardNumber, expirationDate);

      // adding a new book into the cart
      Item item1 = new Book();
      item1.Title = "War and Peace";
      item1.Price = 20.12f;
      cart.AddItem(item1);

      // adding a new CD into the cart
      Item item2 = new CompactDisc();
      item2.Title = "Kind of Blue";
      item2.Price = 11.97f;
      cart.AddItem(item2);

      // printing out the current contents of the cart
      Summarize(cart);

      // removing the book from the cart
      cart.RemoveItem(item1);

      // adding another book into the cart
      Item item3 = new Book();
      item3.Title = "Crime and Punishment";
      item3.Price = 31.33f;
      cart.AddItem(item3);

      // printing out the current contents of the cart
      Summarize(cart);

      // trying to purchase the contents of the cart 
      // expecting an exception to be thrown
      try {
        cart.Purchase();
      }
      catch(PurchaseProblemException e) {
        Console.WriteLine("Could not purchase the items: " + 
          "caught expected exception " + e.GetType().FullName);
      }

      // releasing the cart instance
      cart.Remove();
    }
    catch(Exception e) {
      Console.WriteLine("Caught an unexpected exception: ");
      Console.WriteLine(e);
      Console.WriteLine("Make sure you started the AppServer and deployed Cart example !!!");
    }
    Console.ReadLine();
  }

  private static void Summarize(Cart cart) {
    Console.WriteLine("======= Cart Summary ========");
    IList items = cart.GetContents();
    for(int i = 0; i < items.Count; i++) {
      Item current = (Item) items[i];
      Console.WriteLine("Item N" + (i + 1)); 
      Console.WriteLine("Title: " + current.Title); 
      Console.WriteLine("Price: $" + current.Price); 
      Console.WriteLine(""); 
    }
    Console.WriteLine("Total: $" + cart.GetTotalPrice());
    Console.WriteLine("=============================");
    Console.WriteLine(""); 
  }

}
